% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landslides.R
\docType{data}
\name{lsl}
\alias{lsl}
\alias{study_mask}
\title{Landslide dataset from Southern Ecuador}
\format{
The landslide dataset consists of two objects (CRS: UTM zone 17S; EPSG:32717):
\enumerate{
    \item{\code{lsl}} {A \code{data.frame} object representing the coordinates of landslide initiation points with 350 rows and 8 columns.}
    \item{\code{study_mask}  {An \code{sf}-object delineating the natural part of the study area.}
    }
}
}
\source{
Landslide dataset of the RSAGA package: \code{data("landslides", package = "RSAGA")}.

 \strong{Landslide Data:}

  Muenchow, J., Brenning, A., Richter, R. (2012): Geomorphic process rates of
  landslides along a humidity gradient in the tropical Andes, Geomorphology
  139-140, 271-284. DOI: 10.1016/j.geomorph.2011.10.029.

  Stoyan, R. (2000): Aktivitaet, Ursachen und Klassifikation der Rutschungen
  in San Francisco/Suedecuador. Unpublished diploma thesis, University of
  Erlangen-Nuremberg, Germany.
}
\usage{
lsl
}
\description{
Data used in the "Statistical learning for geographic data" chapter in Geocomputation with R.
See \url{http://geocompr.robinlovelace.net/spatial-cv.html} for details.
}
\examples{
data("lsl", "study_mask", package = "spDataLarge")
}
\seealso{
\code{?ta.tif}
}
\keyword{datasets}
