#' Dataset landsat
#'
#' This is a dataset containing the four bands (2, 3, 4, 5) of the Landsat 8 image for
#' the area of Zion National Park. A scale factor should be applied before using the data:   
#' \url{https://www.usgs.gov/faqs/how-do-i-use-a-scale-factor-landsat-level-2-science-products}
#'
#' @format A multilayer geotiff file
#'
#' @examples
#'
#' system.file("raster/landsat.tif", package = "spDataLarge")
#'
#' @name landsat.tif
#'
#'
#' @source \url{http://landsat-pds.s3.amazonaws.com/L8/038/034/LC80380342015230LGN00/}
NULL

#' Dataset nlcd
#'
#' This is a dataset containing a simplified version of the National Land Cover Database 2011 product for
#' the Zion National Park area
#'
#' @format A geotiff file
#'
#' @examples
#'
#' system.file("raster/nlcd.tif", package = "spDataLarge")
#'
#' @name nlcd.tif
#'
#' @source \url{https://www.mrlc.gov/nlcd2011.php}
NULL


#' Dataset nlcd2011
#'
#' This is a dataset containing the National Land Cover Database 2011 product for
#' the Zion National Park area
#'
#' @format A geotiff file
#'
#' @examples
#'
#' system.file("raster/nlcd2011.tif", package = "spDataLarge")
#'
#' @name nlcd2011.tif
#'
#' @source \url{https://www.mrlc.gov/nlcd2011.php}
NULL



#' New Zeleand elevation raster data
#'
#' Elevation raster data of the New Zealand area from the Mapzen Terrain Service.
#' For teaching purposes only
#'
#' @format A geotiff file
#'
#' @examples
#'
#' system.file("raster/nz_elev.tif", package = "spDataLarge")
#'
#' @name nz_elev.tif
#'
#' @seealso
#' See the elevatr package: https://cran.r-project.org/web/packages/elevatr
#'
#' @source \url{https://aws.amazon.com/public-datasets/terrain/}
NULL


#' Dataset srtm
#'
#' This is a dataset containing the elevation raster data from SRTM of
#' the Zion National Park area
#'
#' @format A geotiff file
#'
#' @examples
#'
#' system.file("raster/srtm.tif", package = "spDataLarge")
#'
#' @name srtm.tif
#'
#' @source \url{http://srtm.csi.cgiar.org/SRT-ZIP/SRTM_V41/SRTM_Data_GeoTiff/srtm_14_05.zip}
NULL
