% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_learner_stack.R
\name{make_learner_stack}
\alias{make_learner_stack}
\title{Make a stack of sl3 learners}
\usage{
make_learner_stack(...)
}
\arguments{
\item{...}{Each argument is a list that will be passed to
\code{\link{make_learner}}}
}
\value{
An \code{sl3} \code{Stack} consisting of the learners passed in as
arguments the \code{list} argument to this function. This \code{Stack} has
all of the standard methods associated with such objects.
}
\description{
Produce a stack of learners by passing in a list with IDs for the learners.
The resultant stack of learners may then be used as normal.
}
\examples{
# constructing learners with default settings
sl_stack_easy <- make_learner_stack(
  "Lrnr_mean", "Lrnr_glm_fast",
  "Lrnr_xgboost"
)

# constructing learners with arguments passed in
sl_stack <- make_learner_stack(
  "Lrnr_mean",
  list("Lrnr_hal9001",
    n_folds = 10,
    use_min = TRUE
  )
)
}
