% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{call_with_args}
\alias{call_with_args}
\title{Call with filtered argument list}
\usage{
call_with_args(fun, args, other_valid = list(), keep_all = FALSE,
  silent = FALSE, ignore = c())
}
\arguments{
\item{fun}{A \code{function} whose signature will be used to reduce the}

\item{args}{A \code{list} of function arguments to use.}

\item{other_valid}{A \code{list} of function arguments names that are valid,
but not formals of \code{fun}.}

\item{keep_all}{A \code{logical} don't drop arguments, even if they aren't
matched in either the function prototype or other_valid.}

\item{silent}{A \code{logical} indicating whether to pass \code{message}s
when arguments not found in \code{formals} are passed to \code{fun}.}

\item{ignore}{A \code{character} vector indicating which arguments should be dropped}
}
\description{
Call a function with a list of arguments, eliminating any that aren't
matched in the function prototype
}
\keyword{internal}
