% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_ts_weights.R
\docType{class}
\name{Lrnr_ts_weights}
\alias{Lrnr_ts_weights}
\title{Time-specific weighting of prediction losses}
\format{
\code{\link{R6Class}} object.
}
\value{
Learner object with methods for training and prediction. See
\code{\link{Lrnr_base}} for documentation on learners.
}
\description{
A wrapper around any learner that reweights observations. This reweighted
is intended for time series, and ultimately assigns weights to losses. This
learner is particularly useful as a metalearner wrapper. It can be used to
create a time-adaptive ensemble, where a super learner is created in a manner
that places more weight (with max weight of 1) on recent losses, and less
weight is placed on losses further in the past.
}
\section{Parameters}{

\describe{
\item{\code{learner}}{The learner to wrap}
\item{\code{folds=NULL}}{An \code{origami} folds object. If \code{NULL},
folds from the task are used}
\item{\code{full_fit=FALSE}}{If \code{TRUE}, also fit the underlying
learner on the full data. This can then be accessed with
\code{predict_fold(task, fold_number="full")}}
\item{\code{window}}{Observations corresponding to times outside of the
window are assigned weight of 0, and obervations corresponding to times
within the window are assigned weight of 1. The window is defined with
respect to the difference from the maximum time, where all times are
obtained from the task node for time. For example, if the maximum time is
100 and the window is 10, then obervations corresponding to times 90-100
are assigned weight 1 and obervations for times 1-89 are assigned weight 0.
If \code{rate} is provided with \code{window}, then times within the
window are assigned according to the \code{rate} argument (and potentially
\code{delay_decay}), and the times outside of the window are still
assigned weight of 0.}
\item{\code{rate}}{A rate of decay to apply to the losses, where the decay
function is (1-rate)^lag and the lag is the difference from all times to
the maximum time.}
\item{\code{delay_decay}}{The amount of time to delay decaying weights,
for optional use with \code{rate} argument. The delay decay is subtracted
from the lags, such that lags less than the delay decay have lag of 0 and
thus weight of 1. For example, a delay decay of 10 assigns weight 1 to
observations that are no more than 10 time points away from the maximum
time; and for observations that are more than 10 time points away from the
maximum time, the weight is assigned according to the decay function.
In this example, observations corresponding to 11 time points away from the
maximum time would be assigned lag=1, 11-10, when setting the weights
with respect to (1-rate)^lag.}
\item{\code{...}}{Not currently used.}
}
}

\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
