% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_lstm_keras.R
\docType{class}
\name{Lrnr_lstm_keras}
\alias{Lrnr_lstm_keras}
\title{Long short-term memory Recurrent Neural Network (LSTM) with Keras}
\format{
An \code{\link[R6]{R6Class}} object inheriting from
\code{\link{Lrnr_base}}.
}
\value{
A learner object inheriting from \code{\link{Lrnr_base}} with
methods for training and prediction. For a full list of learner
functionality, see the complete documentation of \code{\link{Lrnr_base}}.
}
\description{
This learner supports long short-term memory (LSTM) recurrent neural network
algorithm. This learner uses the \code{keras} package. Note that all
preprocessing, such as differencing and seasonal effects for time series
should be addressed before using this learner. Desired lags of the time series
should be added as predictors before using the learner.
}
\section{Parameters}{

\itemize{
\item \code{batch_size}: How many times should the training data be used to
train the neural network?
\item \code{units}: Positive integer, dimensionality of the output space.
\item \code{dropout}: Float between 0 and 1. Fraction of the input units to
drop.
\item \code{recurrent_dropout}: Float between 0 and 1. Fraction of the units
to drop for the linear transformation of the recurrent state.
\item \code{activation}: Activation function to use. If you pass NULL, no
activation is applied (e.g., "linear" activation: \code{a(x) = x}).
\item \code{recurrent_activation}: Activation function to use for the
recurrent step.
\item \code{recurrent_out}: Activation function to use for the output step.
\item \code{epochs}: Number of epochs to train the model.
\item \code{lr}: Learning rate.
\item \code{layers}: How many LSTM layers. Only allows for 1 or 2.
\item \code{callbacks}: List of callbacks, which is a set of functions to
be applied at given stages of the training procedure. Default callback
function \code{callback_early_stopping} stops training if the validation
loss does not improve across \code{patience} number of epochs.
\item \code{...}: Other parameters passed to \code{\link[keras]{keras}}.
}
}

\examples{
\dontrun{
library(origami)
data(bsds)

# make folds appropriate for time-series cross-validation
folds <- make_folds(bsds,
  fold_fun = folds_rolling_window, window_size = 500,
  validation_size = 100, gap = 0, batch = 50
)

# build task by passing in external folds structure
task <- sl3_Task$new(
  data = bsds,
  folds = folds,
  covariates = c(
    "weekday", "temp"
  ),
  outcome = "cnt"
)

# create tasks for taining and validation (simplifed example)
train_task <- training(task, fold = task$folds[[1]])
valid_task <- validation(task, fold = task$folds[[1]])

# instantiate learner, then fit and predict (simplifed example)
lstm_lrnr <- Lrnr_lstm_keras$new(batch_size = 1, epochs = 200)
lstm_fit <- lstm_lrnr$train(train_task)
lstm_preds <- lstm_fit$predict(valid_task)
}
}
\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
