% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_gts.R
\docType{class}
\name{Lrnr_gts}
\alias{Lrnr_gts}
\title{Grouped Time-Series Forecasting}
\format{
\code{\link{R6Class}} object.
}
\value{
Learner object with methods for training and prediction. See
\code{\link{Lrnr_base}} for documentation on learners.
}
\description{
This learner supports prediction using grouped time-series modeling, using
\pkg{hts}. Fitting is done with \code{\link[hts]{hts}} and prediction is
performed via \code{\link[hts]{forecast.gts}}.
}
\section{Parameters}{

\describe{
\item{\code{method)}}{Method for distributing forecasts within hierarchy.
See details of \code{\link[hts]{forecast.gts}}.}
\item{\code{weights)}}{Weights used for "optimal combination" method:
\code{weights="ols"} uses an unweighted combination (as described in
Hyndman et al 2011); \code{weights="wls"} uses weights based on forecast
variances (as described in Hyndman et al 2015); \code{weights="mint"}
uses a full covariance estimate to determine the weights (as described
in Hyndman et al 2016); \code{weights="nseries"} uses weights based on
the number of series aggregated at each node.}
\item{\code{fmethod)}}{Forecasting method to use for each series.}
\item{\code{algorithms)}}{An algorithm to be used for computing the
combination forecasts (when \code{method=="comb"}). The combination
forecasts are based on an ill-conditioned regression model. "lu"
indicates LU decomposition is used; "cg" indicates a conjugate gradient
method; "chol" corresponds to a Cholesky decomposition; "recursive"
indicates the recursive hierarchical algorithm of Hyndman et al (2015);
"slm" uses sparse linear regression. Note that \code{algorithms =
    "recursive"} and \code{algorithms = "slm"} cannot be used if
\code{weights="mint"}.}
\item{\code{covariance)}}{Type of the covariance matrix to be used with
\code{weights="mint"}: either a shrinkage estimator ("shr") with
shrinkage towards the diagonal; or a sample covariance matrix ("sam").}
\item{\code{keep.fitted)}}{If \code{TRUE}, keep fitted values at the bottom
level.}
\item{\code{keep.resid)}}{If \code{TRUE}, keep residuals at the bottom
level.}
\item{\code{positive)}}{If \code{TRUE}, forecasts are forced to be strictly
positive (by setting \code{lambda=0}).}
\item{\code{lambda)}}{Box-Cox transformation parameter.}
\item{\code{level}}{Level used for "middle-out" method (only used when
\code{method = "mo"}).}
\item{\code{parallel}}{If \code{TRUE}, import \pkg{parallel} to allow
parallel processing.}
\item{\code{num.cores}}{If \code{parallel = TRUE}, specify how many cores
are going to be used.}
}
}

\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_expSmooth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
