% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrnr_expSmooth.R
\docType{class}
\name{Lrnr_expSmooth}
\alias{Lrnr_expSmooth}
\title{Exponential Smoothing state space model}
\format{
\code{\link{R6Class}} object.
}
\value{
Learner object with methods for training and prediction. See
\code{\link{Lrnr_base}} for documentation on learners.
}
\description{
This learner supports exponential smoothing models using
\code{\link[forecast]{ets}}.
}
\section{Parameters}{

\itemize{
\item \code{model="ZZZ"}: Three-character string identifying method. In all
cases, "N"=none, "A"=additive, "M"=multiplicative, and "Z"=automatically
selected. The first letter denotes the error type, second letter denotes
the trend type, third letter denotes the season type. For example, "ANN"
is simple exponential smoothing with additive errors, "MAM" is
multiplicative Holt-Winters' methods with multiplicative errors, etc.
\item \code{damped=NULL}: If TRUE, use a damped trend (either additive or
multiplicative). If NULL, both damped and non-damped trends will be tried
and the best model (according to the information criterion ic) returned.
\item \code{alpha=NULL}: Value of alpha. If NULL, it is estimated.
\item \code{beta=NULL}: Value of beta. If NULL, it is estimated.
\item \code{gamma=NULL}: Value of gamma. If NULL, it is estimated.
\item \code{phi=NULL}: Value of phi. If NULL, it is estimated.
\item \code{lambda=NULL}: Box-Cox transformation parameter. Ignored if
\code{NULL}. When lambda is specified, \code{additive.only} is set to
\code{TRUE}.
\item \code{additive.only=FALSE}: If \code{TRUE}, will only consider
additive models.
\item \code{biasadj=FALSE}: Use adjusted back-transformed mean for Box-Cox
transformations.
\item \code{lower=c(rep(1e-04, 3), 0.8)}: Lower bounds for the parameters
(alpha, beta, gamma, phi).
\item \code{upper=c(rep(0.9999,3), 0.98)}: Upper bounds for the parameters
(alpha, beta, gamma, phi)
\item \code{opt.crit="lik"}: Optimization criterion.
\item \code{nmse=3}: Number of steps for average multistep MSE (1 <= nmse
<= 30).
\item \code{bounds="both"}" Type of parameter space to impose: "usual"
indicates all parameters must lie between specified lower and upper
bounds; "admissible" indicates parameters must lie in the admissible
space; "both" (default) takes the intersection of these regions.
\item \code{ic="aic"}: Information criterion to be used in model
selection.
\item \code{restrict=TRUE}: If TRUE, models with infinite variance will not
be allowed.
\item \code{allow.multiplicative.trend=FALSE}: If TRUE, models with
multiplicative trend are allowed when searching for a model.
\item \code{use.initial.values=FALSE}: If \code{TRUE} and model is of class
"ets", then the initial values in the model are also not re-estimated.
\item \code{n.ahead}: The forecast horizon. If not specified, returns
forecast of size \code{task$X}.
\item \code{freq=1}: the number of observations per unit of time.
\item \code{...}: Other parameters passed to \code{\link[forecast]{ets}.}
}
}

\examples{
library(origami)
data(bsds)

folds <- make_folds(bsds,
  fold_fun = folds_rolling_window, window_size = 500,
  validation_size = 100, gap = 0, batch = 50
)

task <- sl3_Task$new(
  data = bsds,
  folds = folds,
  covariates = c(
    "weekday", "temp"
  ),
  outcome = "cnt"
)

expSmooth_lrnr <- make_learner(Lrnr_expSmooth)

train_task <- training(task, fold = task$folds[[1]])
valid_task <- validation(task, fold = task$folds[[1]])

expSmooth_fit <- expSmooth_lrnr$train(train_task)
expSmooth_preds <- expSmooth_fit$predict(valid_task)
}
\seealso{
Other Learners: 
\code{\link{Custom_chain}},
\code{\link{Lrnr_HarmonicReg}},
\code{\link{Lrnr_arima}},
\code{\link{Lrnr_bartMachine}},
\code{\link{Lrnr_base}},
\code{\link{Lrnr_bayesglm}},
\code{\link{Lrnr_bilstm}},
\code{\link{Lrnr_caret}},
\code{\link{Lrnr_cv_selector}},
\code{\link{Lrnr_cv}},
\code{\link{Lrnr_dbarts}},
\code{\link{Lrnr_define_interactions}},
\code{\link{Lrnr_density_discretize}},
\code{\link{Lrnr_density_hse}},
\code{\link{Lrnr_density_semiparametric}},
\code{\link{Lrnr_earth}},
\code{\link{Lrnr_gam}},
\code{\link{Lrnr_ga}},
\code{\link{Lrnr_gbm}},
\code{\link{Lrnr_glm_fast}},
\code{\link{Lrnr_glmnet}},
\code{\link{Lrnr_glm}},
\code{\link{Lrnr_grf}},
\code{\link{Lrnr_gru_keras}},
\code{\link{Lrnr_gts}},
\code{\link{Lrnr_h2o_grid}},
\code{\link{Lrnr_hal9001}},
\code{\link{Lrnr_haldensify}},
\code{\link{Lrnr_hts}},
\code{\link{Lrnr_independent_binomial}},
\code{\link{Lrnr_lightgbm}},
\code{\link{Lrnr_lstm_keras}},
\code{\link{Lrnr_mean}},
\code{\link{Lrnr_multiple_ts}},
\code{\link{Lrnr_multivariate}},
\code{\link{Lrnr_nnet}},
\code{\link{Lrnr_nnls}},
\code{\link{Lrnr_optim}},
\code{\link{Lrnr_pca}},
\code{\link{Lrnr_pkg_SuperLearner}},
\code{\link{Lrnr_polspline}},
\code{\link{Lrnr_pooled_hazards}},
\code{\link{Lrnr_randomForest}},
\code{\link{Lrnr_ranger}},
\code{\link{Lrnr_revere_task}},
\code{\link{Lrnr_rpart}},
\code{\link{Lrnr_rugarch}},
\code{\link{Lrnr_screener_augment}},
\code{\link{Lrnr_screener_coefs}},
\code{\link{Lrnr_screener_correlation}},
\code{\link{Lrnr_screener_importance}},
\code{\link{Lrnr_sl}},
\code{\link{Lrnr_solnp_density}},
\code{\link{Lrnr_solnp}},
\code{\link{Lrnr_stratified}},
\code{\link{Lrnr_subset_covariates}},
\code{\link{Lrnr_svm}},
\code{\link{Lrnr_tsDyn}},
\code{\link{Lrnr_ts_weights}},
\code{\link{Lrnr_xgboost}},
\code{\link{Pipeline}},
\code{\link{Stack}},
\code{\link{define_h2o_X}()},
\code{\link{undocumented_learner}}
}
\concept{Learners}
\keyword{data}
