% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{runR}
\alias{runR}
\title{Returns a function that runs an R command}
\usage{
runR(symbolList)
}
\arguments{
\item{symbolList}{A list of permitted symbols in the R command}
}
\value{
A function that can be passed as one of the elements of
\code{\link{slServer}}'s \code{interface} argument.
}
\description{
If you set this as a part of your interface, like:
\code{runR=shinylight::runR(c("+", "plot", "c", "x", "y"))}
then you can call it from Javascript like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{rrpc.call("runR", \{
 Rcommand:"2+2"
\}, function(x) \{console.log(x);\});
rrpc.call("runR", \{
 Rcommand:"y<-c(2,0,1);plot(c(1,2,3),y);y",
 'rrpc.resultformat': \{
   type: 'png',
   width: 200,
   height: 300,
 \}
\}, function(x) \{img.setAttribute('src', x.plot[0])\});
}\if{html}{\out{</div>}}
}
\examples{
server <- slServer(
  port = 50050,
  interface = list(
    run_the_users_r_code = runR(
      list("c", "$", "list", "+", "-", "/", "*", "sqrt")
    )
  )
)
# ...
slStop(server)
}
