% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_dependence2D.R
\name{sv_dependence2D}
\alias{sv_dependence2D}
\alias{sv_dependence2D.default}
\alias{sv_dependence2D.shapviz}
\alias{sv_dependence2D.mshapviz}
\title{2D SHAP Dependence Plot}
\usage{
sv_dependence2D(object, ...)

\method{sv_dependence2D}{default}(object, ...)

\method{sv_dependence2D}{shapviz}(
  object,
  x,
  y,
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  jitter_height = NULL,
  interactions = FALSE,
  add_vars = NULL,
  ...
)

\method{sv_dependence2D}{mshapviz}(
  object,
  x,
  y,
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  jitter_height = NULL,
  interactions = FALSE,
  add_vars = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class "(m)shapviz".}

\item{...}{Arguments passed to \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}}.}

\item{x}{Feature name for x axis. Can be a vector/list if \code{object} is
of class "shapviz".}

\item{y}{Feature name for y axis. Can be a vector/list if \code{object} is
of class "shapviz".}

\item{viridis_args}{List of viridis color scale arguments, see
\code{?ggplot2::scale_color_viridis_c}. The default points to the global option
\code{shapviz.viridis_args}, which corresponds to
\code{list(begin = 0.25, end = 0.85, option = "inferno")}.
These values are passed to \verb{ggplot2::scale_color_viridis_*()}.
For example, to switch to a standard viridis scale, you can either change the
default via \code{options(shapviz.viridis_args = list())}, or set
\code{viridis_args = list()}. Only relevant if \code{color_var} is not \code{NULL}.}

\item{jitter_width}{The amount of horizontal jitter. The default (\code{NULL}) will
use a value of 0.2 in case \code{v} is discrete, and no jitter otherwise.
(Numeric variables are considered discrete if they have at most 7 unique values.)
Can be a vector/list if \code{v} is a vector.}

\item{jitter_height}{Similar to \code{jitter_width} for vertical scatter.}

\item{interactions}{Should SHAP interaction values be plotted? The default (\code{FALSE})
will show the rowwise sum of the SHAP values of \code{x} and \code{y}. If \code{TRUE}, will
use twice the SHAP interaction value (requires SHAP interactions).}

\item{add_vars}{Optional vector of feature names, whose SHAP values should be added
to the sum of the SHAP values of \code{x} and \code{y} (only if \code{interactions = FALSE}).
A use case would be a model with geographic x and y coordinates, along with some
additional locational features like distance to the next train station.}
}
\value{
An object of class "ggplot" (or "patchwork") representing a dependence plot.
}
\description{
Scatterplot of two features, showing the sum of their SHAP values on the color scale.
This allows to visualize the combined effect of two features, including interactions.
A typical application are models with latitude and longitude as features (plus
maybe other regional features that can be passed via \code{add_vars}).

If SHAP interaction values are available, setting \code{interactions = TRUE} allows
to focus on pure interaction effects (multiplied by two). In this case, \code{add_vars}
has no effect.
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_dependence2D(default)}: Default method.

\item \code{sv_dependence2D(shapviz)}: 2D SHAP dependence plot for "shapviz" object.

\item \code{sv_dependence2D(mshapviz)}: 2D SHAP dependence plot for "mshapviz" object.

}}
\examples{
dtrain <- xgboost::xgb.DMatrix(
  data.matrix(iris[, -1]), label = iris[, 1], nthread = 1
)
fit <- xgboost::xgb.train(data = dtrain, nrounds = 10, nthread = 1)
sv <- shapviz(fit, X_pred = dtrain, X = iris)
sv_dependence2D(sv, x = "Petal.Length", y = "Species")
sv_dependence2D(sv, x = c("Petal.Length", "Species"), y = "Sepal.Width")

# SHAP interaction values
sv2 <- shapviz(fit, X_pred = dtrain, X = iris, interactions = TRUE)
sv_dependence2D(sv2, x = "Petal.Length", y = "Species", interactions = TRUE)
sv_dependence2D(
  sv2, x = "Petal.Length", y = c("Species", "Petal.Width"), interactions = TRUE
)

# mshapviz object
mx <- split(sv, f = iris$Species)
sv_dependence2D(mx, x = "Petal.Length", y = "Sepal.Width")
}
\seealso{
\code{\link[=sv_dependence]{sv_dependence()}}
}
