% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{sf_bbox}
\alias{sf_bbox}
\title{sf bbox}
\usage{
sf_bbox(obj, x = NULL, y = NULL)
}
\arguments{
\item{obj}{matrix, data.frame, \code{sfg}, \code{sfc} or \code{sf} object.}

\item{x}{x geometry column}

\item{y}{y geometry column}
}
\description{
Calculates the bounding box of coordinates. This does not read the "bbox" attribute,
it re-calculates the bounding box from the geometry coordinates
}
\examples{

## data.frame
df <- data.frame(
 id1 = c(1,1,1,1,1,1,1,1,2,2,2,2)
 , id2 = c(1,1,1,1,2,2,2,2,1,1,1,1)
 , x = c(0,0,1,1,1,1,2,2,3,4,4,3)
 , y = c(0,1,1,0,1,2,2,1,3,3,4,4)
)

sf_bbox( obj = df[, c("x","y")] )
sf_bbox( obj = df, x = "x", y = "y" )

## sfg objects
pt <- sfg_point(obj = df[1, ], x = "x", y = "y", z = "id1")
mpt <- sfg_multipoint(obj = df, x = "x", y = "y")
ls <- sfg_linestring(obj = df, x = "x", y = "y")
mls <- sfg_multilinestring(obj = df, x = "x", y = "y")
p <- sfg_polygon(obj = df, x = "x" , y = "y")
mp <- sfg_multipolygon(obj = df, x = "x", y = "y", close = FALSE )

sf_bbox( pt )
sf_bbox( mpt )
sf_bbox( ls )
sf_bbox( mls )
sf_bbox( p )
sf_bbox( mp )

## sfc objects
pt <- sfc_point(obj = df, x = "x", y = "y", z = "id1")
mpt <- sfc_multipoint(obj = df, x = "x", y = "y", multipoint_id = "id1")
ls <- sfc_linestring(obj = df, x = "x", y = "y", linestring_id = "id1")
mls <- sfc_multilinestring(obj = df, x = "x", y = "y", multilinestring_id = "id1")
p <- sfc_polygon(
  obj = df
  , x = "x"
  , y = "y"
  , polygon_id = "id1"
  , linestring_id = "id2"
  , close = FALSE
  )
mp <- sfc_multipolygon(
  obj = df
  , x = "x"
  , y = "y"
  , multipolygon_id = "id1"
  , linestring_id = "id2"
  , close = FALSE
  )

sf_bbox( pt )
sf_bbox( mpt )
sf_bbox( ls )
sf_bbox( mls )
sf_bbox( p )
sf_bbox( mp )

## sf objects
pt <- sf_point(obj = df, x = "x", y = "y", z = "id1")
mpt <- sf_multipoint(obj = df, x = "x", y = "y", multipoint_id = "id1")
ls <- sf_linestring(obj = df, x = "x", y = "y", linestring_id = "id1")
mls <- sf_multilinestring(obj = df, x = "x", y = "y", multilinestring_id = "id1")
p <- sf_polygon(
  obj = df
  , x = "x"
  , y = "y"
  , polygon_id = "id1"
  , linestring_id = "id2"
  , close = FALSE
  )
mp <- sf_multipolygon(
  obj = df
  , x = "x"
  , y = "y"
  , multipolygon_id = "id1"
  , linestring_id = "id2"
  , close = FALSE
  )

sf_bbox( pt )
sf_bbox( mpt )
sf_bbox( ls )
sf_bbox( mls )
sf_bbox( p )
sf_bbox( mp )

## you can use it to update a bounding-box if it gets corrupted
attr( mpt, "bbox" ) <- c(1:5)
mpt ## incorrect values
attr( mpt, "bbox" ) <- sf_bbox( mpt )
mpt ## back to correct values

}
