% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{electricity}
\alias{electricity}
\title{Data on U.S. electric power generation}
\format{
A data frame with 123 observations on the following 9 variables.
\describe{ \item{firm}{Firm identification.} \item{cost}{Total cost in 1970,
MM USD.} \item{output}{Output in million KwH.} \item{lprice}{Labor price.}
\item{lshare}{Labor's cost share.} \item{cprice}{Capital price.}
\item{cshare}{Capital's cost share.} \item{fprice}{Fuel price.}
\item{fshare}{Fuel's cost share.} }
}
\source{
\url{http://pages.stern.nyu.edu/~wgreene/Text/tables/tablelist5.htm}
}
\description{
This dataset is on electric power generation in the United States.
}
\details{
The dataset is from Christensen and Greene (1976) and has also been used in
Greene (1990).
}
\examples{

str(electricity)
summary(electricity)
}
\references{
Christensen, L.R., and W.H. Greene. 1976. Economies of scale in
US electric power generation. \emph{The Journal of Political Economy},
\bold{84}:655--676.

Greene, W.H. 1990. A Gamma-distributed stochastic frontier model.
\emph{Journal of Econometrics}, \bold{46}:141--163.
}
\keyword{datasets}
