% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serp.method.R
\name{logLik.serp}
\alias{logLik.serp}
\title{Log-likelihood for a fitted serp object}
\usage{
\method{logLik}{serp}(object, ...)
}
\arguments{
\item{object}{An object of class \code{serp}.}

\item{...}{additional arguments.}
}
\value{
A single numeric value of model log-likelihood
}
\description{
Returns the Log-likelihood for a fitted object of class \code{serp}.
}
\examples{
library(serp)
m <- serp(rating ~ temp + contact, slope = "parallel", link = "loglog",
          data = wine)
logLik(m)
}
\seealso{
\code{\link{serp}}, \code{\link{AIC.serp}}, \code{\link{BIC.serp}},
\code{\link{coef.serp}}
}
