% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_rerun_check.R
\name{lavaan_rerun_check}
\alias{lavaan_rerun_check}
\title{Compatibility Check for 'lavaan_rerun'}
\usage{
lavaan_rerun_check(fit, print_messages = TRUE)
}
\arguments{
\item{fit}{The output from \code{lavaan}, such as \code{\link[lavaan:cfa]{lavaan::cfa()}} and
\code{\link[lavaan:sem]{lavaan::sem()}}.}

\item{print_messages}{Logical. If \code{TRUE}, will print messages about the
check. If \code{FALSE}, the messages will be attached to the return value
as an attribute. Default is \code{TRUE}.}
}
\value{
A single-element vector. If confirmed to be supported, will
return 0. If not confirmed be support but may still work, return 1.
If confirmed to be not yet supported, will return a negative
number, the value of this number without the negative sign is the
number of tests failed.
}
\description{
Gets a 'lavaan' output and checks whether it is
supported by \code{\link[=lavaan_rerun]{lavaan_rerun()}}.
}
\details{
This function is not supposed to be used by users. It is
called by \code{\link[=lavaan_rerun]{lavaan_rerun()}} to see if the analysis being passed to
it is supported. If not, messages will be printed to indicate why.
}
\examples{

dat <- cfa_dat

mod <-
"
f1 =~ x4 + x5 + x6
"
dat_gp <- dat
dat$gp <- rep(c("gp1", "gp2"), length.out = nrow(dat_gp))

fit01 <- lavaan::sem(mod, dat)
# If supported, returns a zero.
lavaan_rerun_check(fit01)

fit05 <- lavaan::cfa(mod, dat, group = "gp")
# If not supported, returns a negative number.
lavaan_rerun_check(fit05)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
