% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_embedding.R
\name{embedGraphUmap}
\alias{embedGraphUmap}
\title{Embed a graph into a UMAP, Uniform Manifold Approximation and Projection for Dimension Reduction, <https://github.com/lmcinnes/umap>, <doi:10.21105/joss.00861>}
\usage{
embedGraphUmap(
  graph,
  min.prob = 0.001,
  min.visited.verts = 1000,
  n.cores = 1,
  max.hitting.nn.num = 0,
  max.commute.nn.num = 0,
  min.prob.lower = 1e-07,
  n.neighbors = 40,
  n.epochs = 1000,
  spread = 15,
  min.dist = 0.001,
  return.all = FALSE,
  n.sgd.cores = n.cores,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{graph}{input igraph object}

\item{min.prob}{numeric Minimum probability for proximity when calculating hitting time per neighbors (default=1e-3)}

\item{min.visited.verts}{numeric Minimum number of vertices visted when calculating hitting time per neighbors (default=1000)}

\item{n.cores}{numeric Number of cores to use (default=1)}

\item{max.hitting.nn.num}{numeric Maximum adjacencies for calculating hitting time per neighbor, hitting_time_per_neighbors() (default=0)}

\item{max.commute.nn.num}{numeric Maximum adjacencies for calculating commute time per neighbor, commute_time_per_node() (default=0)}

\item{min.prob.lower}{numeric Probability threshold to continue iteration in depth first search hitting time, dfs_hitting_time() (default=1e-7)}

\item{n.neighbors}{numeric Number of neighbors (default=40)}

\item{n.epochs}{numeric Number of epochs to use during the optimization of the embedded coordinates (default=1000). See 'n_epochs' in uwot::umap()}

\item{spread}{numeric The effective scale of embedded points (numeric default=15). See 'spread' in uwot::umap()}

\item{min.dist}{numeric The effective minimum distance between embedded points (default=0.001). See 'min.dist' in uwot::umap()}

\item{return.all}{boolean If TRUE, return list(adj.info=adj.info, commute.times=commute.times, umap=umap). Otherwise, just return UMAP(default=FALSE)}

\item{n.sgd.cores}{numeric Number of cores to use during stochastic gradient descent. If set to > 1, then results will not be reproducible, even if 'set.seed' is called with a fixed seed before running (default=n_threads) See 'n_sgd_threads' in uwot::umap()}

\item{verbose}{boolean Verbose output (default=TRUE)}

\item{...}{Additional arguments passed to embedKnnGraph()}
}
\value{
resulting UMAP embedding
}
\description{
Embed a graph into a UMAP, Uniform Manifold Approximation and Projection for Dimension Reduction, <https://github.com/lmcinnes/umap>, <doi:10.21105/joss.00861>
}
