% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_embedding.R
\name{embedKnnGraph}
\alias{embedKnnGraph}
\title{Embed a k-nearest neighbor (kNN) graph within a UMAP. Used within embedGraphUmap(). Please see McInnes et al <doi:10.21105/joss.00861> for the UMAP description and implementation.}
\usage{
embedKnnGraph(
  commute.times,
  n.neighbors,
  names = NULL,
  n.cores = 1,
  n.epochs = 1000,
  spread = 15,
  min.dist = 0.001,
  n.sgd.cores = n.cores,
  target.dims = 2,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{commute.times}{graph commute times from get_nearest_neighbors(). The definition of commute_time(u, v) is the expected time starting at u = to reach v and then return to u .}

\item{n.neighbors}{numeric Number of neighbors}

\item{names}{vector of names for UMAP rownames (default=NULL)}

\item{n.cores}{numeric Number of cores to use (except during stochastic gradient descent) (default=1). See 'n_threads' in uwot::umap()}

\item{n.epochs}{numeric Number of epochs to use during the optimization of the embedded coordinates (default=1000). See 'n_epochs' in uwot::umap()}

\item{spread}{numeric The effective scale of embedded points (numeric default=15). See 'spread' in uwot::umap()}

\item{min.dist}{numeric The effective minimum distance between embedded points (default=0.001). See 'min.dist' in uwot::umap()}

\item{n.sgd.cores}{numeric Number of cores to use during stochastic gradient descent. If set to > 1, then results will not be reproducible, even if 'set.seed' is called with a fixed seed before running (default=n.cores) See 'n_sgd_threads' in uwot::umap()}

\item{target.dims}{numeric Dimensions for 'n_components' in uwot::umap(n_components=target.dims) (default=2)}

\item{verbose}{boolean Verbose output (default=TRUE)}

\item{...}{arguments passed to uwot::umap()}
}
\value{
resulting kNN graph embedding within a UMAP
}
\description{
Embed a k-nearest neighbor (kNN) graph within a UMAP. Used within embedGraphUmap(). Please see McInnes et al <doi:10.21105/joss.00861> for the UMAP description and implementation.
}
