% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hindcast_pomdp.R
\name{hindcast_pomdp}
\alias{hindcast_pomdp}
\alias{compare_pomdp}
\title{hindcast_pomdp}
\usage{
hindcast_pomdp(
  transition,
  observation,
  reward,
  discount,
  obs,
  action,
  state_prior = rep(1, dim(observation)[[1]])/dim(observation)[[1]],
  alpha = NULL,
  ...
)
}
\arguments{
\item{transition}{Transition matrix, dimension n_s x n_s x n_a}

\item{observation}{Observation matrix, dimension n_s x n_z x n_a}

\item{reward}{reward matrix, dimension n_s x n_a}

\item{discount}{the discount factor}

\item{obs}{a given sequence of observations}

\item{action}{the corresponding sequence of actions}

\item{state_prior}{initial belief state, optional, defaults to uniform
over states}

\item{alpha}{the matrix of alpha vectors returned by \code{\link{sarsop}}}

\item{...}{additional arguments to \code{\link{appl}}.}
}
\value{
a list, containing: a data frame with columns for time, obs, action, and optimal action,
and an array containing the posterior belief distribution at each time t
}
\description{
Compare historical actions to what pomdp recommendation would have been.
}
\examples{
m <- fisheries_matrices()
\donttest{ ## Takes > 5s
if(assert_has_appl()){
alpha <- sarsop(m$transition, m$observation, m$reward, 0.95, precision = 10)
sim <- hindcast_pomdp(m$transition, m$observation, m$reward, 0.95,
                     obs = rnorm(21, 15, .1), action = rep(1, 21),
                     alpha = alpha)

}}
}
