% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_exploreData.R
\name{plotDiscreteData}
\alias{plotDiscreteData}
\alias{exploreDataTTE}
\alias{exploreDataCat}
\alias{exploreDataCountHist}
\alias{plotDiscreteData.aux}
\title{Plot non Gaussian data}
\usage{
plotDiscreteData(object, outcome = "continuous", verbose = FALSE, ...)
}
\arguments{
\item{object}{an SaemixData object returned by the \code{\link{saemixData}} function.}

\item{outcome}{type of outcome (valid types are "TTE", "binary", "categorical", "count")}

\item{verbose}{whether to print messages (defaults to FALSE)}

\item{\dots}{additional arguments, used to pass graphical options (to be implemented, currently not available)}
}
\description{
This function provides exploration plots for non Gaussian longitudinal data (work in progress)
}
\details{
This function is a very rough first attempt at automatically creating plots to explore
discrete longitudinal data.
\itemize{
\item for TTE data, a KM plot will be produced
\item for count, categorical and binary data, a plot showing the proportion of each score/category across time will be shown
These plots can be stratified over a covariate in the data set (currently only categorical covariates)
by passing an argument which.cov='name' to the call
#'
}
}
\examples{
# Time-to-event data
data(lung.saemix)

saemix.data<-saemixData(name.data=lung.saemix,header=TRUE,name.group=c("id"),
name.predictors=c("time","status","cens"),name.response=c("status"),
name.covariates=c("age", "sex", "ph.ecog", "ph.karno", "pat.karno", "wt.loss","meal.cal"),
units=list(x="days",y="",covariates=c("yr","","-","\%","\%","cal","pounds")))

# Plots a KM survival plot
plotDiscreteData(saemix.data, outcome="TTE")
# Plots a KM survival plot, stratified by sex
plotDiscreteData(saemix.data, outcome="TTE", which.cov="sex")

# Count data
data(rapi.saemix)
saemix.data<-saemixData(name.data=rapi.saemix, name.group=c("id"),
                 name.predictors=c("time","rapi"),name.response=c("rapi"),
                 name.covariates=c("gender"),units=list(x="months",y="",covariates=c("")))

# Plots a histogram of the counts
plotDiscreteData(saemix.data, outcome="count")

}
\references{
Brendel, K, Comets, E, Laffont, C, Laveille, C, Mentre, F.
Metrics for external model evaluation with an application to the population
pharmacokinetics of gliclazide, Pharmaceutical Research 23 (2006),
2036-2049.

Holford, N. The Visual Predictive Check: superiority to standard diagnostic
(Rorschach) plots (Abstract 738), in: 14th Meeting of the Population
Approach Group in Europe, Pamplona, Spain, 2005.

Ron Keizer, tutorials on VPC TODO
}
\seealso{
\code{\link{SaemixObject}}, \code{\link{saemix}},
\code{\link{saemix.plot.vpc}}, \code{\link{simulateDiscreteSaemix}}
}
\author{
Emmanuelle Comets \href{mailto:emmanuelle.comets@inserm.fr}{emmanuelle.comets@inserm.fr}
}
\keyword{plot}
