% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findMCMC_strong_corrs.R
\name{findMCMC_strong_corrs}
\alias{findMCMC_strong_corrs}
\title{findMCMC_strong_corrs}
\usage{
findMCMC_strong_corrs(
  mcmcList,
  corrMethod = "pearson",
  minCorr = 0.3,
  namesToRemove = NULL
)
}
\arguments{
\item{mcmcList}{R object of type mcmc.list that contains the MCMC output}

\item{corrMethod}{character: designates the kind of correlation calculated among "pearson" (the default, for linear relationships), "spearman" (for monotone relationships) or "hoeffd" (for general associations - i.e. dependencies - between parameters)}

\item{minCorr}{double, between 0 and 1: minimum level of (absolute) correlation to report.}

\item{namesToRemove}{R object (can be a vector, matrix, array, list...) all components of which must be of character type: will remove parameters whose names partially match one of tghese components.}
}
\description{
finds the couples of parameters of a MCMC.list object that have at least a minCorr level of (absolute) correlation
}
\details{
In case corrMethod equals "hoeffd", the hoeffd function in the Hmisc package will be used. This can be very slow. Therefore a warning message is printed in this case.
}
\examples{
 #\code{
# for examples with Nimble or Greta, see the Vignette.
# condition variable of whether installation is OK with Jags to avoid error durong package check
condition_jags<-TRUE
if (nchar(system.file(package='rjags'))==0) {condition_jags<-FALSE}
if (nchar(system.file(package='runjags'))==0) {condition_jags<-FALSE}
if (condition_jags)
{suppressWarnings(temp<-runjags::testjags(silent=TRUE))
 if(!(temp$JAGS.available&temp$JAGS.found&temp$JAGS.major==4)) {condition_jags<-FALSE}}

if (condition_jags) {
#generating data
set.seed(1)
y1000<-rnorm(n=1000,mean=600,sd=30)
ModelData <-list(mass = y1000,nobs = length(y1000))

#writing the Jags code as a character chain in R
modeltotransfer<-"model {

# Priors
population.mean ~ dunif(0,5000)
population.sd ~ dunif(0,100)

# Precision = 1/variance: Normal distribution parameterized by precision in Jags
population.variance <- population.sd * population.sd
precision <- 1 / population.variance

# Likelihood
for(i in 1:nobs){
  mass[i] ~ dnorm(population.mean, precision)
 }
 }"

#specifying the initial values
ModelInits <- function()
{list (population.mean = rnorm(1,600,90), population.sd = runif(1, 1, 30))}
params <- c("population.mean", "population.sd", "population.variance")
K<-3
set.seed(1)
Inits<-lapply(1:K,function(x){ModelInits()})

# running runMCMC_btadjust with MCMC_language="Jags":
set.seed(1)
out.mcmc.Coda<-runMCMC_btadjust(MCMC_language="Jags", code=modeltotransfer,
data=ModelData,
Nchains=K, params=params, inits=Inits,
niter.min=1000, niter.max=300000,
nburnin.min=100, nburnin.max=200000,
thin.min=1, thin.max=1000,
neff.min=1000, conv.max=1.05,
control=list(print.diagnostics=TRUE, neff.method="Coda"))

findMCMC_strong_corrs(out.mcmc.Coda)
}
#}
}
