% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rheader}
\alias{rheader}
\title{Create a header}
\usage{
rheader(..., format = "xx", .lst = NULL)
}
\arguments{
\item{\dots}{row specifications (either as character vectors or the output
from \code{\link{rrow}} or \code{\link{DataRow}}, \code{\link{LabelRow}},
etc.}

\item{format}{character(1) or function. The format label (string) or
formatter function to apply to the cell values passed via \code{...}. See
\code{\link[formatters]{list_valid_format_labels}} for currently supported
format labels.}

\item{.lst}{list. An already-collected list of arguments to be used instead
of the elements of \code{\dots}. Arguments passed via \code{\dots} will be
ignored if this is specified.}
}
\value{
a \code{InstantiatedColumnInfo} object.
}
\description{
Create a header
}
\examples{

h1 <- rheader(c("A", "B", "C"))

h2 <- rheader(
  rrow(NULL, rcell("group 1", colspan = 2), rcell("group 2", colspan = 2)),
  rrow(NULL, "A", "B", "A", "B")
)

h1

h2

}
\seealso{
Other compatibility: 
\code{\link{rrowl}()},
\code{\link{rrow}()},
\code{\link{rtable}()}
}
\concept{compatibility}
