% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{as_result_df}
\alias{as_result_df}
\title{Generate a Result Data Frame}
\usage{
as_result_df(tt, spec = "v0_experimental", ...)
}
\arguments{
\item{tt}{\code{VTableTree}. The table.}

\item{spec}{character(1). The specification to use to
extract the result data frame. See details}

\item{...}{Passed to spec-specific result data frame conversion function.}
}
\description{
Generate a Result Data Frame
}
\details{
Result data frame specifications may differ in the exact information they include and
the form in which they represent it. Specifications whose names end in "_experimental"
are subject to change without notice, but specifications without the "_experimental"
suffix will remain available \emph{including any bugs in their construction} indefinitely.
}
\note{
This function may eventually be migrated to a separate package, and so should
not be called via \code{::}
}
\examples{

lyt <- basic_table() \%>\%
    split_cols_by("ARM") \%>\%
    split_rows_by("STRATA1") \%>\%
  analyze(c("AGE", "BMRKR2"))

tbl <- build_table(lyt, ex_adsl)
as_result_df(tbl)
}
