% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_afun_utils.R
\name{rcell}
\alias{rcell}
\alias{non_ref_rcell}
\title{Cell value constructors}
\usage{
rcell(
  x,
  format = NULL,
  colspan = 1L,
  label = NULL,
  indent_mod = NULL,
  footnotes = NULL,
  align = NULL,
  format_na_str = NULL
)

non_ref_rcell(
  x,
  is_ref,
  format = NULL,
  colspan = 1L,
  label = NULL,
  indent_mod = NULL,
  refval = NULL,
  align = "center",
  format_na_str = NULL
)
}
\arguments{
\item{x}{ANY. Cell value}

\item{format}{if \code{FUN} does not return a formatted \code{\link{rcell}}
then the \code{format} is applied}

\item{colspan}{integer(1). Columnspan value.}

\item{label}{character(1). Label or Null. If non-null, it will be looked at
when determining row labels.}

\item{indent_mod}{numeric. Modifier for the default indent position for the
structure created by this function(subtable, content table, or row)
\emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{footnotes}{list or NULL. Referential footnote messages for the cell.}

\item{align}{character(1). Alignment the value should be rendered with. See
\code{\link{rtables_aligns}} for currently supported alignments.}

\item{format_na_str}{character(1). String which should be displayed when
formatted if this cell's value(s) are all NA.}

\item{is_ref}{logical(1).  Are  we  in  the reference  column  (ie
.in_ref_col shoul be passed to this argument)}

\item{refval}{ANY. Value to use when in the reference column. Defaults
to \code{NULL}}
}
\value{
An object representing the value within a single cell within a
populated table. The underlying structure of this object is an
implementation detail and sholud not be relied upon beyond calling
accessors for the class.
}
\description{
Construct a cell value and associate formatting, labeling,
indenting, and column spanning information with it.
}
\details{
\code{non_ref_rcell} provides the common \emph{blank for cells in
the reference column, this value otherwise}, and should be passed the value
of \code{.in_ref_col} when it is used.
}
\note{
currently column spanning is only supported for defining header
structure.
}
