% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccd_analysis.R
\name{ccd_analysis}
\alias{ccd_analysis}
\title{Response surface regression analysis of CCD data}
\usage{
ccd_analysis(x)
}
\arguments{
\item{x}{the matrix of experimental data that contains columns with the uncoded levels
for each experimental factor and the observed values for the response variable in the
rightmost column.}
}
\value{
The user will be prompted to enter \dQuote{1} for a 3-D plot of the response surface,
or \dQuote{2} to plot the contour of the predicted variance of the response

\dQuote{Data.For.Analysis}, includes the data set and the coding coefficients
    for the transformation of the independent factors

\dQuote{Response.Surface.Summary}, includes the response surface for variable, hypothesis
   tests for linear, quadratic, and crossproduct terms, lack of fit test, parameter
   estimates, the factor ANOVA table, canonical analysis, and eigenvectors
}
\description{
For the simultaneous production of response surface analysis output by
   \pkg{rsm} used in combination with \pkg{graphics} in the second-order
   polynomial approach. The predictor variables must be named \dQuote{Factor1},
   \dQuote{Factor2}, etc., while the response variable must be named \dQuote{Response}. The
   output includes regression model fitting and plot of the
   fitted response surface.
}
\examples{
if(interactive()){
 ccd_analysis(ExampleData)
 }

}
\references{
Mead, R., Gilmour, S. G., and Mead, A. 2012. Statistical Principles for the Design of
   Experiments: Applications to Real Experiments. Cambridge University Press, Cambridge.

Panneton, B., Philion, H., Dutilleul, P., Theriault, R., and Khelifi, M. 1999. Full
   factorial design versus central composite design: Statistical comparison and
   experimental implications for spray droplet deposition. Transactions of the American
   Society of Agricultural Engineers 42:877-883.
}
