% Generated by roxygen2 (4.0.2): do not edit by hand
\name{length.rdeque}
\alias{length.rdeque}
\title{Return the number of elements in an rdeque}
\usage{
\method{length}{rdeque}(x)
}
\arguments{
\item{x}{rdeque to get the length of.}
}
\value{
a vector of length 1 with the number of elements.
}
\description{
Returns the number of elements in an rdeque.
}
\details{
Runs in \eqn{O(1)} time, as this information is stored seperately and updated on every insert/remove.
}
\examples{
d <- rdeque()
d <- insert_front(d, "a")
print(length(d))         # 1
d <- insert_back(d, "b")
print(length(d))         # 2
}
\seealso{
\code{\link{empty}} for checking whether an rdeque is empty.
}

