% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roughnet.R
\name{roughnet}
\alias{roughnet}
\title{Create a rough network}
\usage{
roughnet(
  g,
  roughness = c(1, 1),
  bowing = c(1, 1),
  font = "30px Arial",
  width = NULL,
  height = NULL,
  elementId = NULL,
  chunk_name = "canvas"
)
}
\arguments{
\item{g}{igraph object}

\item{roughness}{numeric vector for roughness of vertices and edges}

\item{bowing}{numeric vector for bowing of vertices and edges}

\item{font}{font size and font family for labels}

\item{width}{width}

\item{height}{height}

\item{elementId}{DOM id}

\item{chunk_name}{markdown specific}
}
\value{
htmlwidget containing the drawn network
}
\description{
plot a network using rough.js
}
\details{
the function recognizes the following attributes
Vertex attributes (e.g. V(g)$shape):
\itemize{
\item \emph{shape} one of "circle", "rectangle", "heart", "air", "earth", "fire", "water"
\item \emph{fill} vertex fill color
\item \emph{color} vertex stroke color
\item \emph{stroke} stroke size
\item \emph{fillstyle} one of "hachure", "solid", "zigzag", "cross-hatch", "dots", "sunburst", "dashed", "zigzag-line"
\item \emph{size} vertex size
\item \emph{label} vertex label
\item \emph{pos} position of vertex label (c)enter, (n)orth, (e)ast, (s)outh, (w)est
}

Edge attributes (e.g. E(g)$color):
\itemize{
\item \emph{color} edge color
\item \emph{width} edge width
}

Default values are used if one of the attributes is not found.

The result of a roughnet call can be printed to file with \code{save_roughnet()}

More details on roughjs can be found on https://github.com/rough-stuff/rough/wiki
}
\examples{
library(igraph)

g <- make_graph("Zachary")
V(g)$shape <- "circle"
V(g)$shape[c(1, 34)] <- "rectangle"
V(g)$fill <- c("#E41A1C", "#377EB8", "#4DAF4A", "#984EA3")[membership(cluster_louvain(g))]
V(g)$fillstyle <- c("hachure", "zigzag", "cross-hatch", "dots")[membership(cluster_louvain(g))]
V(g)$color <- "black"
V(g)$size <- 30
V(g)$stroke <- 2
E(g)$color <- "#AEAEAE"
roughnet(g, width = 960, height = 600)

}
