% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_rds.R
\name{rotate_rds}
\alias{rotate_rds}
\alias{rotate_rds_date}
\alias{rotate_rds_time}
\title{Serialize R objects to disk (with backup)}
\usage{
rotate_rds(
  object,
  file = "",
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL,
  ...,
  on_change_only = FALSE
)

rotate_rds_date(
  object,
  file = "",
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL,
  ...,
  age = -1L,
  on_change_only = FALSE
)

rotate_rds_time(
  object,
  file = "",
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL,
  ...,
  age = -1L,
  on_change_only = FALSE
)
}
\arguments{
\item{object}{\R object to serialize.}

\item{file}{a \link[base]{connection} or the name of the file where the \R object
    is saved to or read from.}

\item{ascii}{a logical.  If \code{TRUE} or \code{NA}, an ASCII
    representation is written; otherwise (default), a binary one is used.
    See the comments in the help for \code{\link[base]{save}}.}

\item{version}{the workspace format version to use.  \code{NULL}
    specifies the current default version (3). The only other supported
    value is 2, the default from \R 1.4.0 to \R 3.5.0.}

\item{compress}{a logical specifying whether saving to a named file is
    to use \code{"gzip"} compression, or one of \code{"gzip"},
    \code{"bzip2"} or \code{"xz"} to indicate the type of compression to
    be used.  Ignored if \code{file} is a connection.}

\item{refhook}{a hook function for handling reference objects.}

\item{...}{
  Arguments passed on to \code{\link[=rotate]{rotate}}, \code{\link[=rotate_date]{rotate_date}}, \code{\link[=rotate_time]{rotate_time}}
  \describe{
    \item{\code{max_backups}}{maximum number of backups to keep
\itemize{
\item an \code{integer} scalar: Maximum number of backups to keep
}

In addition for timestamped backups the following value are supported:
\itemize{
\item a \code{Date} scalar: Remove all backups before this date
\item a \code{character} scalar representing a Date in ISO format (e.g. \code{"2019-12-31"})
\item a \code{character} scalar representing an Interval in the form \code{"<number> <interval>"} (see below for more info)
}}
    \item{\code{size}}{scalar \code{integer}, \code{character} or \code{Inf}. Backup/rotate only if
\code{file} is larger than this size. \code{Integers} are interpreted as bytes. You
can pass \code{character} vectors that contain a file size suffix like \verb{1k}
(kilobytes), \verb{3M} (megabytes), \verb{4G} (gigabytes), \verb{5T} (terabytes). Instead
of these short forms you can also be explicit and use the IEC suffixes
\code{KiB}, \code{MiB}, \code{GiB}, \code{TiB}. In Both cases \code{1} kilobyte is \code{1024} bytes, 1
\code{megabyte} is \code{1024} kilobytes, etc... .

(if \code{age} \emph{and} \code{size} are provided, both criteria must be \code{TRUE} to
trigger rotation)}
    \item{\code{dir}}{\code{character} scalar. The directory in which the backups
of \code{file} are stored (defaults to \code{dirname(file)})}
    \item{\code{compression}}{Whether or not backups should be compressed
\itemize{
\item \code{FALSE} for uncompressed backups,
\item \code{TRUE} for zip compression; uses \code{\link[=zip]{zip()}}
\item a scalar \code{integer} between \code{1} and \code{9} to specify a compression
level (requires the
\href{https://CRAN.R-project.org/package=zip}{zip} package,
see its documentation for details)
\item the \code{character} scalars \code{"utils::zip()"} or \code{"zip::zipr"} to force a
specific zip command
}}
    \item{\code{dry_run}}{\code{logical} scalar. If \code{TRUE} no changes are applied to the
file system (no files are created or deleted)}
    \item{\code{verbose}}{\code{logical} scalar. If \code{TRUE} additional informative \code{messages}
are printed}
    \item{\code{create_file}}{\code{logical} scalar. If \code{TRUE} create an empty file in
place of \code{file} after rotating.}
    \item{\code{format}}{a scalar \code{character} that can be a subset of of valid
\code{strftime()} formatting strings. The default setting is
\code{"\%Y-\%m-\%d--\%H-\%M-\%S"}.
\itemize{
\item You can use an arbitrary number of dashes anywhere in the format, so
\code{"\%Y-\%m-\%d--\%H-\%M-\%S"} and \code{"\%Y\%m\%d\%H\%M\%S"} are both legal.
\item \code{T} and \verb{_} can also be used as separators. For example, the following
datetime formats are also possible:
\verb{\%Y-\%m-\%d_\%H-\%M-\%S} (Python logging default),
\verb{\%Y\%m\%dT\%H\%M\%S} (\href{https://en.wikipedia.org/wiki/ISO_8601}{ISO 8601})
\item All datetime components except \verb{\%Y} are optional. If you leave out part
of the timestamp, the first point in time in the period is assumed. For
example (assuming the current year is 2019) \verb{\%Y} is identical to
\code{2019-01-01--00-00-00}.
\item The timestamps must be lexically sortable, so \code{"\%Y-\%m-\%d"} is legal,
\code{"\%m-\%d-\%Y"} and \verb{\%Y-\%d} are not.
}}
    \item{\code{now}}{The current \code{Date} or time (\code{POSIXct}) as a scalar. You can pass a
custom value here to to override the real system time. As a convenience you
can also pass in \code{character} strings that follow the guidelines outlined
above for \code{format}, but please note that these differ from the formats
understood by \code{\link[=as.POSIXct]{as.POSIXct()}} or \code{\link[=as.Date]{as.Date()}}.}
    \item{\code{overwrite}}{\code{logical} scalar. If \code{TRUE} overwrite backups if a backup
of the same name (usually due to timestamp collision) exists.}
  }}

\item{on_change_only}{\code{logical} scalaror a \code{list}. Rotate only if \code{object}
is different from the object saved in \code{file}. If a \code{list}, arguments
that will be passed on to \code{data.table::all.equal} (only when both obects
are \code{data.tables})}

\item{age}{minimum age after which to backup/rotate a file; can be
\itemize{
\item a \code{character} scalar representing an Interval in the form
\code{"<number> <interval>"} (e.g. \code{"2 months"}, see \emph{Intervals} section below).
\item a \code{Date} or a \code{character} scalar representing a Date for
a fixed point in time after which to backup/rotate. See \code{format} for
which Date/Datetime formats are supported by rotor.
}

(if \code{age} \emph{and} \code{size} are provided, both criteria must be \code{TRUE} to
trigger rotation)}
}
\value{
the path to \code{file} (invisibly)
}
\description{
The \verb{rotate_rds*()} functions are wrappers around \link[base:readRDS]{base::saveRDS()} that
create a backup of the destination file (if it exists) instead of just
overwriting it.
}
\note{
The default value for \code{age} is different for \code{rotate_rds_date()} (\code{-1})
than for \code{\link[=rotate_date]{rotate_date()}} (\code{1}) to make it a bit safer. This means if you
execute \code{rotate_date()} twice on the same file on a given day it will
silently not rotate the file, while \code{rotate_rds_date()} will throw an
error.
}
\examples{
dest <- tempfile()
rotate_rds(iris, dest)
rotate_rds(iris, dest)
rotate_rds(iris, dest)

list_backups(dest)

# cleanup
unlink(list_backups(dest))
unlink(dest)
}
