% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_min}
\alias{roll_min}
\title{Rolling Minimums}
\usage{
roll_min(x, width, weights = rep(1, width), min_obs = width,
  complete_obs = FALSE, na_restore = FALSE, online = TRUE)
}
\arguments{
\item{x}{vector or matrix. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then each value is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
An object of the same class and dimension as \code{x} with the rolling and expanding
minimums.
}
\description{
A function for computing the rolling and expanding minimums of time-series data.
}
\examples{
n <- 15
x <- rnorm(n)
weights <- 0.9 ^ (n:1)

# rolling minimums with complete windows
roll_min(x, width = 5)

# rolling minimums with partial windows
roll_min(x, width = 5, min_obs = 1)

# expanding minimums with partial windows
roll_min(x, width = n, min_obs = 1)

# expanding minimums with partial windows and weights
roll_min(x, width = n, min_obs = 1, weights = weights)
}
