% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{weightedsqnorm}
\alias{weightedsqnorm}
\title{Generic squared Euclidean norm.}
\usage{
weightedsqnorm(x, s)
}
\arguments{
\item{x}{A \code{vector} of numeric values or a scalar value.}

\item{s}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.

\strong{Note}

\code{x}, and \code{s} should have the same inner dimension.}
}
\value{
An object of class "LazyTensor".
}
\description{
Symbolic binary operation for weighted squared norm of a LazyTensor.
}
\details{
\code{weightedsqnorm(x, s)} returns a \code{LazyTensor} that encodes, symbolically,
the weighted squared norm of a vector \code{x} with weights stored in the LazyTensor
\code{s}.

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Simple vector operations.
}
\examples{
\dontrun{
x <- matrix(runif(100 * 3), 100, 3) # arbitrary R matrix, 100 rows, 3 columns
s <- matrix(runif(100 * 3), 100, 3) # arbitrary R matrix, 100 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
s_j <- LazyTensor(s, index = 'j')   # creating LazyTensor from matrix s, 
                                    # indexed by 'j'

wsqn_xy <- weightedsqnorm(x_i, s_j)
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
