% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{weightedsqdist}
\alias{weightedsqdist}
\title{Generic squared distance.}
\usage{
weightedsqdist(x, y, s)
}
\arguments{
\item{x}{A \code{vector} of numeric values or a scalar value.}

\item{y}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}

\item{s}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor".
}
\description{
Symbolic binary operation for weighted squared distance of a LazyTensor.
}
\details{
\code{weightedsqdist(x, y, s)} returns a \code{LazyTensor} that encodes,
symbolically, the weighted squared distance of a vector \code{x} with weights
stored in the LazyTensor \code{s}, same as \code{weightedsqnorm(x - y, s)}.

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Simple vector operations.

\strong{Note}

\code{x}, \code{y} and \code{s} should all have the same inner dimension.
}
\examples{
\dontrun{
x <- matrix(runif(100 * 3), 100, 3) # arbitrary R matrix, 100 rows, 3 columns
y <- matrix(runif(100 * 3), 100, 3) # arbitrary R matrix, 100 rows, 3 columns
s <- matrix(runif(100 * 3), 100, 3) # arbitrary R matrix, 100 rows, 3 columns

x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
y_j <- LazyTensor(y, index = 'j')   # creating LazyTensor from matrix y, 
                                    # indexed by 'j'
s_i <- LazyTensor(s, index = 'i')   # creating LazyTensor from matrix s, 
                                    # indexed by 'i'                                                                        

wsqd_xy <- weightedsqdist(x_i, y_j, s_i)    # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
