% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{ternaryop.LazyTensor}
\alias{ternaryop.LazyTensor}
\title{Build a ternary operation}
\usage{
ternaryop.LazyTensor(x, y, z, opstr, dim_check_type = "sameor1", dim_res = NA)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}

\item{y}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}

\item{z}{A \code{LazyTensor}, a \code{ComplexLazyTensor}r, a vector of numeric values,
or a scalar value.}

\item{opstr}{A text string corresponding to an operation.}

\item{dim_check_type}{A string to specify if, and how, we should check input
dimensions.
Supported values are:
\itemize{
\item {\strong{"same"}:}{ \strong{x} and \strong{y} should have the same inner dimension;}
\item {\strong{"sameor1"} (default):}{ \strong{x} and \strong{y} should have the same inner
dimension or at least one of them should be of dimension 1;}
\item {\strong{NA}:}{ no dimension restriction.}
}}

\item{dim_res}{NA (default) or an integer corresponding to the inner
dimension of the output \code{LazyTensor}. If NA, \strong{dim_res} is set to the
maximum between the inner dimensions of the three input \code{LazyTensor}s.}
}
\value{
An object of class "LazyTensor".
}
\description{
Symbolically applies \strong{opstr} operation to \strong{x}, \strong{y} and \strong{z}.
}
\examples{
\dontrun{
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
