% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{sumsoftmaxweight_reduction}
\alias{sumsoftmaxweight_reduction}
\title{Sum of weighted Soft-Max reduction.}
\usage{
sumsoftmaxweight_reduction(x, index, weight)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor} indexed by 'i' and 'j'.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}

\item{weight}{An optional object (\code{LazyTensor} or \code{ComplexLazyTensor}) that
specifies scalar or vector-valued weights.}
}
\value{
A matrix corresponding to the Sum of weighted Soft-Max reduction.
}
\description{
Sum of weighted Soft-Max reduction.
}
\details{
\code{sumsoftmaxweight_reduction(x, index, weight)} will:
\itemize{
\item{if \strong{index = i},}{ return the Log-Sum-Exp reduction of \strong{x}
over the \strong{i} indices (rows);}
\item{if \strong{index = j},}{ return the Log-Sum-Exp reduction of \strong{x}
over the \strong{j} indices (columns).}
}

\strong{Note}

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) 
x_i <- LazyTensor(x, index = 'i') 
y <- matrix(runif(100 * 3), 100, 3)
y_j <- LazyTensor(y, index = 'j')

V_ij <- x_i - y_j   # weight matrix
S_ij = sum(V-ij^2)     

# sumsoftmaxweight reduction over the 'i' indices
ssmaxw_red <- sumsoftmaxweight_reduction(S_ij, 'i', V_ij) 

}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
