% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{sum.LazyTensor}
\alias{sum.LazyTensor}
\title{Sum operation or Sum reduction.}
\usage{
\method{sum}{LazyTensor}(x, index = NA)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the summation is indexed by
\strong{i} (rows), or \strong{j} (columns).
It can be NA (default) when no reduction is desired.}
}
\value{
FIXME
}
\description{
Sum unary operation, or Sum reduction for LazyTensor.
}
\details{
Given that \code{x} is a \code{LazyTensor}, \code{sum(x, index)} will :
\itemize{
\item if \strong{index = "i"}, return the sum reduction of \strong{x} over the "i"
indexes.
\item if \strong{index = "j"}, return the sum reduction of \strong{x} over the "j"
indexes.
\item if \strong{index = NA} (default), return a new \code{LazyTensor} object
representing the sum of the values of the vector.
}

\strong{Notes}

If \strong{index = NA}, \code{x} input argument should be a \code{LazyTensor} encoding a
parameter vector.

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\author{
Chloe Serre-Combe, Amelie Vernay

Chloe Serre-Combe, Amelie Vernay

#' @examples
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

sum_x <- sum(x_i)                   # LazyTensor object
sum_red_x <- sum(x_i, "i")          # sum reduction indexed by 'i'
}
}
\keyword{internal}
