% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{square}
\alias{square}
\title{Element-wise square.}
\usage{
square(x)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}
}
\value{
An object of class "LazyTensor" if the function is called with a
\code{LazyTensor}, and an object of class "numeric", "matrix", or "array" otherwise,
same as the input class.
}
\description{
Symbolic unary operation for element-wise square.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{square(x)} returns a \code{LazyTensor} that
encodes, symbolically, the element-wise square of \code{x} ;
else, is equivalent to the "^2" R operator.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
                                    
Square_x <- square(x_i)             # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
