% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{sqdist}
\alias{sqdist}
\title{Squared distance.}
\usage{
sqdist(x, y)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}

\item{y}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor".
}
\description{
Symbolic binary operation for squared Euclidean distance.
}
\details{
\code{sqdist(x)} returns a \code{LazyTensor} that encodes, symbolically,
the squared Euclidean distance between \code{x} and \code{y}, same as \code{sqnorm2(x - y)}.

\strong{Note}

\code{x} and \code{y} input arguments should have the same inner dimension or be of
dimension 1.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
                                    
SqD_x <- sqdist(x_i)                # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
