% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{sign}
\alias{sign}
\title{Element-wise sign.}
\usage{
sign(x)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}
}
\value{
An object of class "LazyTensor" if the function is called with a
\code{LazyTensor}, and an object of class "numeric", "matrix", or "array" otherwise,
depending on the input class (see R default \code{sign()} function).
}
\description{
Symbolic unary operation for element-wise sign.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{sign(x)} returns a \code{LazyTensor} that encodes,
symbolically, the element-wise sign of \code{x} in {-1, 0, +1} ; else, computes R
default sign function.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
                                    
Sign_x <- sign(x_i)                 # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
