% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkeops_options.R
\name{set_rkeops_options}
\alias{set_rkeops_options}
\title{Initialize or update \code{rkeops} options in \code{R} global options scope}
\usage{
set_rkeops_options(input = NULL)
}
\arguments{
\item{input}{a list of named values corresponding to rkeops options
to be updated.}
}
\value{
None
}
\description{
\code{rkeops} user-defined operators requires specific options to control
their behavior at runtime (precision, verbosity, use of GPU, debug flag).
Their current values can be printed with \code{\link[=get_rkeops_options]{get_rkeops_options()}}.
}
\details{
See \code{\link[=def_rkeops_options]{def_rkeops_options()}} for more detailed about these options.

If no input is provided, the functions \code{set_rkeops_options()}
initializes all \code{rkeops} options in the \code{R} global options scope
(i.e. options available by calling \code{options()} or
\verb{getOptions(<option_name>)}) with default values.

If some input is provided, i.e. objects defining compile options and/or
runtime options (see Details), \code{rkeops} global options are updated
accordingly.

Some helper functions are available to enable some options,
see \code{\link[=rkeops_use_float32]{rkeops_use_float32()}}, \code{\link[=rkeops_use_float64]{rkeops_use_float64()}},
\code{\link[=rkeops_use_cpu]{rkeops_use_cpu()}}, \code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}},
\code{\link[=rkeops_enable_verbosity]{rkeops_enable_verbosity()}}, \code{\link[=rkeops_disable_verbosity]{rkeops_disable_verbosity()}}.
}
\examples{
set_rkeops_options()

}
\seealso{
\code{\link[=def_rkeops_options]{def_rkeops_options()}}, \code{\link[=get_rkeops_options]{get_rkeops_options()}},
\code{\link[=rkeops_use_float32]{rkeops_use_float32()}}, \code{\link[=rkeops_use_float64]{rkeops_use_float64()}},
\code{\link[=rkeops_use_cpu]{rkeops_use_cpu()}}, \code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}},
\code{\link[=rkeops_enable_verbosity]{rkeops_enable_verbosity()}}, \code{\link[=rkeops_disable_verbosity]{rkeops_disable_verbosity()}}
}
\author{
Ghislain Durif
}
