% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{round}
\alias{round}
\title{Element-wise rounding function.}
\usage{
round(x, ...)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}

\item{d}{A scalar value. (or a complex ?)}
}
\value{
An object of class "LazyTensor" if the function is called with a
\code{LazyTensor}, and an object of class "numeric", "matrix", or "array" otherwise,
depending on the input class (see R default \code{round()} function).
}
\description{
Symbolic binary operation for element-wise rounding function.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{round(x, d)} returns a \code{LazyTensor} that
encodes, symbolically, the element-wise rounding of \code{x} to \code{d} decimal places ;
else, computes R default rounding function.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
                                    
Round_x <- round(x_i, 2)            # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
