% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkeops_options.R
\name{rkeops_use_gpu}
\alias{rkeops_use_gpu}
\title{Enable GPU-computing when calling user-defined operators}
\usage{
rkeops_use_gpu(device = -1)
}
\arguments{
\item{device}{integer, GPU device id to be used for computations. Default
value is \code{-1}, meaning that default GPU will be used, which is
equivalent to \code{0}. It is recommended to use default GPU and manage GPU
assignment outside R (see details).}
}
\value{
None
}
\description{
Set up \code{rkeops} options to use GPU computing when calling
user-defined operators.
}
\details{
If you have compiled GPU-compatible operators (which requires a
Nvidia GPU and CUDA), you can call the function \code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}}
to specifically run computations on GPU.

It is recommended to use default GPU (i.e. \code{device = -1} or \code{0}) and
manage GPU assignment outside R by setting the environment variable
\code{CUDA_VISIBLE_DEVICES}.

\strong{Note:} The default behavior in \code{rkeops} is to use CPU computing, thus
calling the function \code{\link[=rkeops_use_gpu]{rkeops_use_gpu()}} is mandatory to run
computations on GPU.

To disable GPU computing, run \code{\link[=rkeops_use_cpu]{rkeops_use_cpu()}}.
}
\examples{
\dontrun{
rkeops_use_gpu()
}
}
\seealso{
\code{\link[=rkeops_use_cpu]{rkeops_use_cpu()}}, \code{\link[=set_rkeops_options]{set_rkeops_options()}}
}
\author{
Ghislain Durif
}
