% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkeops_options.R
\name{rkeops_use_float32}
\alias{rkeops_use_float32}
\title{Use 32bit float precision in computations}
\usage{
rkeops_use_float32()
}
\value{
None
}
\description{
Set up \code{rkeops} options to use 32bit float precision in computation
when calling user-defined operators.
}
\details{
\strong{Note:} Default behavior is to use 32bit float precision in
computation.

\strong{Important:} 32bit float precision computations are faster than
64bit float, however the lower precision may have a huge effect on the
accuracy of your computation and validity of your results
in certain applications.

Since R only manages 64bit float (a.k.a "double") numbers, the input and
output are converted to 32bit float before computation and back to
64bit float after computation.
}
\examples{
\dontrun{
rkeops_use_float32()
}
}
\seealso{
\code{\link[=rkeops_use_float64]{rkeops_use_float64()}}, \code{\link[=set_rkeops_options]{set_rkeops_options()}}
}
\author{
Ghislain Durif
}
