% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkeops-package.R
\docType{package}
\name{rkeops-package}
\alias{rkeops-package}
\alias{rkeops}
\title{rkeops}
\description{
RKeOps: kernel operations on GPU, with autodiff, without memory overflows in R
}
\details{
RKeOps is the R package interfacing the cpp/cuda library
\href{https://www.kernel-operations.io/}{KeOps}. It provides
standard R functions that can be used in any R (>=3) codes.

The KeOps library provides seamless kernel operations on GPU, with
auto-differentiation and without memory overflows.

With RKeOps, you can compute generic reductions of very large arrays whose
entries are given by a mathematical formula. It combines a tiled reduction
scheme with an automatic differentiation engine. It is perfectly suited to
the computation of Kernel dot products and the associated gradients, even
when the full kernel matrix does not fit into the GPU memory.

For more information, please read the vignettes
(\code{browseVignettes("rkeops")}) and visit
\url{https://www.kernel-operations.io/}.
}
\references{
\insertRef{JMLR:v22:20-275}{rkeops}
}
\author{
\itemize{
\item \href{http://imag.umontpellier.fr/~charlier/}{Benjamin Charlier}
\item Amelie Vernay
\item Chloe Serre-Combe
\item \href{https://gdurif.perso.math.cnrs.fr/}{Ghislain Durif}
\item \href{https://www.jeanfeydy.com}{Jean Feydy}
\item \href{http://helios.mi.parisdescartes.fr/~glaunes/}{Joan Alexis Glaunès}
\item François-David Collin
}
}
