% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{relu}
\alias{relu}
\title{Element-wise ReLU function.}
\usage{
relu(x)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor".
}
\description{
Symbolic unary operation for element-wise ReLU function.
}
\details{
\code{relu(x)} returns a \code{LazyTensor} that encodes, symbolically,
the element-wise ReLU of \code{x} (\code{0} if \code{x < 0}, \code{x} if \code{x >= 0}).
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
                                    
ReLU_x <- relu(x_i)                 # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
