% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{preprocess_reduction}
\alias{preprocess_reduction}
\title{Preprocess reduction operation.}
\usage{
preprocess_reduction(x, opstr, index, opt_arg = NA)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{opstr}{A \code{string} formula (like "Sum" or "Max").}

\item{index}{A \code{character} that should be either \strong{i} or \strong{j} to specify
whether if the reduction is indexed by \strong{i} (rows), or \strong{j} (columns).}

\item{opt_arg}{An optional argument : an \code{interger} (for "Kmin" reduction),
a \code{character}, \code{LazyTensor} or a \code{ComplexLazyTensor}.}
}
\value{
A \code{function}.
}
\description{
Returns a \code{function} for a reduction to a \code{LazyTensor} and it is called in
\code{rkeops::reduction.LazyTensor()}.
}
\details{
\code{preprocess_reduction(x, opstr, index)} will :
\itemize{
\item{ if \strong{index = "i"}, return a \code{function} corresponding to the \strong{opstr}
reduction of \strong{x} over the "i" indexes;}
\item{ if \strong{index = "j"}, return a \code{function} corresponding to the \strong{opstr}
reduction of \strong{x} over the "j" indexes.}
}
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

op <- preprocess_reduction(x_i, "Sum", "i")
}
}
\seealso{
\code{\link[=reduction.LazyTensor]{reduction.LazyTensor()}}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
\keyword{internal}
