% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_args.R
\name{parse_extra_args}
\alias{parse_extra_args}
\title{Parse formula for extra arguments in the formula not defined with an
alias in the argument list.}
\usage{
parse_extra_args(formula)
}
\arguments{
\item{formula}{text string, an operator formula (see Details).}
}
\value{
a boolean value indicating if extra args were found in the formula.
}
\description{
RKeOps does not support direct encoding of argument in the formula without
an alias in the argument list. This function check if any argument are
directly encoded in the formula without an alias.
}
\details{
Parse the formula for string such as
\itemize{
\item \code{"YY(<pos>,<dim>)"} where \code{YY} can be a formula input argument type
(\code{Vi}, \code{Vj} or \code{Pm}), \verb{<pos>} is the position of the corresponding input
argument, and \verb{<dim>} its inner dimension.
\item \code{"Var(<pos>,<dim>,<type>)"} where \verb{<pos>} and \verb{<dim>} are the position and
inner dimension (c.f. previous point) and \verb{<type>} is an integer encoding
the formula input argument type with the following relation:
}

|---------|-------------------------|-----------|\tabular{lll}{
   keyword \tab meaning \tab type \cr
   \code{Vi} \tab variable indexed by \code{i} \tab \code{0} \cr
   \code{Vj} \tab variable indexed by \code{j} \tab \code{1} \cr
   \code{Pm} \tab parameter \tab \code{2} \cr
   --------- \tab ------------------------- \tab ----------- \cr
}
}
\author{
Ghislain Durif
}
\keyword{internal}
