% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{one_hot}
\alias{one_hot}
\title{One-hot.}
\usage{
one_hot(x, D)
}
\arguments{
\item{x}{A \code{LazyTensor} encoding a scalar value.}

\item{D}{An \code{integer} corresponding to the output dimension.}
}
\value{
A \code{LazyTensor}.
}
\description{
One-hot
}
\details{
If \code{x} is a scalar value encoded as a \code{LazyTensor},
\code{one_hot(x, D)} encodes, symbolically, a vector of length \strong{D}
whose round(\code{x})-th coordinate is equal to 1, and the other ones to 0.
}
\examples{
\dontrun{
A <- 7
A_LT <- LazyTensor(A) # LazyTensor from scalar A
D <- 7

onehot_x <- one_hot(A_LT, D) # symbolic vector of length D
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
