% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{normalize}
\alias{normalize}
\title{Vector normalization.}
\usage{
normalize(x)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor".
}
\description{
Symbolic unary operation for vector normalization.
}
\details{
\code{normalize(x)} returns a \code{LazyTensor} that encodes, symbolically,
the vector normalization of \code{x} (with the Euclidean norm),
same as \code{rsqrt(sqnorm2(x)) * x}.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
                                    
N_x <- norm2(x_i)                   # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
