% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{norm2}
\alias{norm2}
\title{Euclidean norm.}
\usage{
norm2(x)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor".
}
\description{
Symbolic unary operation for Euclidean norm.
}
\details{
\code{norm2(x)} returns a \code{LazyTensor} that encodes, symbolically,
the Euclidean norm of \code{x}, same as \code{sqrt(x|x)}.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
N_x <- norm2(x_i)                   # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
