% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{min_argmin_reduction}
\alias{min_argmin_reduction}
\title{Min-ArgMin reduction.}
\usage{
min_argmin_reduction(x, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by \strong{i}
(rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the min-argmin reduction.
}
\description{
Min-ArgMin reduction.
}
\details{
\code{min_argmin_reduction(x, index)} will return the min reduction of \code{x}.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

min_argmin_red <- min_argmin_reduction(x_i, "i")  # min reduction indexed by "i"
}
}
\seealso{
\code{\link[=min_argmin]{min_argmin()}}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
