% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{max_argmax}
\alias{max_argmax}
\title{Max-ArgMax.}
\usage{
max_argmax(x, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the max-argmax reduction.
}
\description{
Max-ArgMax reduction.
}
\details{
\code{max_argmax(x, index)} will :
\itemize{
\item if \strong{index = "i"}, return the maximal values of \strong{x} and its
indices over the \strong{i} indices;
\item if \strong{index = "j"}, return the maximal values of \strong{x} and its
indices over the \strong{j} indices.
}

\strong{Note}

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

max_argmax_x <- max_argmax(x_i, "i")  # max argmax reduction indexed by "i"
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
