% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{log}
\alias{log}
\title{Element-wise natural logarithm.}
\usage{
log(x)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor" if the function is called with a
\code{LazyTensor}, and an object of class "numeric", "matrix", or "array" otherwise,
depending on the input class (see R default \code{log()} function).
}
\description{
Symbolic unary operation for element-wise natural logarithm.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{exp(x)} returns a \code{LazyTensor} that encodes,
symbolically, the element-wise natural logarithm of \code{x} ;
else, computes R default logarithm.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
Log_x <- log(x_i)                   # symbolic matrix, 150 rows and 3 columns
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
