% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{is.LazyVector}
\alias{is.LazyVector}
\title{is.LazyVector?}
\usage{
is.LazyVector(x)
}
\arguments{
\item{x}{A \code{LazyTensor} object that we want to know if it is a \code{LazyVector}.}
}
\value{
A boolean, TRUE or FALSE.
}
\description{
Checks whether if the given input is a \code{LazyTensor} encoding
a vector or a single value.
}
\details{
If \code{x} is a vector parameter \code{LazyTensor},
\code{is.LazyVector(x)} returns TRUE, else, returns FALSE.
}
\examples{
\dontrun{
# basic example
scal <- 3.14
cplx <- 2 + 3i
v <- rep(3, 10)
x <- matrix(runif(100 * 3), 100, 3)

# create LazyTensor and ComplexLazyTensor
scal_LT <- LazyTensor(scal)
cplx_LT <- LazyTensor(cplx)
v_LT <- LazyTensor(v)
x_i <- LazyTensor(x, index = 'i')

# call is.LazyVector
is.LazyVector(scal_LT) # returns TRUE
is.LazyVector(cplx_LT) # returns TRUE
is.LazyVector(v_LT) # returns TRUE
is.LazyVector(x_i) # returns FALSE
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
